﻿using UnityEngine;

namespace Ice {
  public static class ObjectUtil {
    public static void DestroyChildrenImmediate(GameObject parent) {
      DestroyChildrenImmediate(parent, _ => true);
    }

    public static void DestroyChildrenImmediate(GameObject parent, System.Func<GameObject, bool> condition) {
      GameObject[] children = new GameObject[parent.transform.childCount];
      for (int i = 0; i < parent.transform.childCount; i++) {
        children[i] = parent.transform.GetChild(i).gameObject;
      }
      foreach (var child in children) {
        if (condition(child)) {
          Object.DestroyImmediate(child.gameObject);
        }
      }
    }

    public static void AppendNameToChildren(GameObject parent, string suffix) {
      foreach (Transform child in parent.transform) {
        child.gameObject.name += suffix;
      }
    }
  }
} // namespace Ice
