﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraFollow : MonoBehaviour {
  public Transform target;
  public float followDistance = 10f;
  public float smoothTime = 1f;

  private Vector3 currentVelocity;

  private void Start() {
    if (target == null) {
      AssignToPlayer();
    }
  }

  private void LateUpdate() {
    transform.position = Vector3.SmoothDamp(
        transform.position, TargetPosition(), ref currentVelocity, smoothTime);
  }

  [Ice.ExposeMethod]
  private void AssignToPlayer() {
    target = FindObjectOfType<Player>().transform;
    transform.position = TargetPosition();
  }

  private Vector3 TargetPosition() {
    return target.transform.position - transform.forward * followDistance;
  }
}
