﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public class Connection : MonoBehaviour {
  public bool Connected {
    get {
      return Other != null;
    }
  }

  public bool Activated { get; private set; }
  public bool DeadEnd { get; set; }
  public Connection Other { get; private set; }

  private Connection other;
  private Piece piece;
  private new Collider collider;
  private float endcapTimer;

  private void Start() {
    piece = GetComponentInParent<Piece>();
    collider = GetComponent<Collider>();
    collider.enabled = false;
  }

  public void ActivateConnection() {
    if (Activated) {
      return;
    }
    if (!Connected) {
      if (!DeadEnd) {
        Debug.LogError("MISSING CONNECTION WITHOUT DEADEND!!");
        Debug.Break();
      }
      return;
    }

    Activated = true;
    // TODO: Fix this in order to handle re-activation.
    collider.enabled = false;
    Other.ActivateSelf();
  }

  private void ActivateSelf() {
    Activated = true;
    // TODO: Fix this in order to handle re-activation.
    collider.enabled = false;
    piece.Activate();
  }

  public void MarkConnected(Connection other) {
    Other = other;
    other.Other = this;
    collider.enabled = true;
  }

  public void MarkDeadEnd(GameObject endcapPrefab) {
    DeadEnd = true;
    StartCoroutine(PlaceEndcap(endcapPrefab));
  }

  private IEnumerator PlaceEndcap(GameObject endcapPrefab) {
    var endPos = transform.position - transform.forward;
    var startPos = endPos + Vector3.up * 2f;
    var rot = Quaternion.Euler(-90, 0, 0);
    var endcap = GameObject.Instantiate(endcapPrefab, startPos, rot);
    endcapTimer = 0;
    var totalTime = 0.3f;
    GameController.Find().endcapSound.Play();
    while (endcapTimer < totalTime) {
      endcapTimer += Time.deltaTime;
      float t = EasingFunction.EaseOutQuart(0, 1, endcapTimer / totalTime);
      endcap.transform.position = Vector3.Lerp(startPos, endPos, t);
      yield return null;
    }
  }


  private void OnDrawGizmos() {
    float size = 0.5f;
    Gizmos.color = DeadEnd ? Color.red : Connected ? Color.white : Color.blue;
    Gizmos.DrawLine(transform.position, transform.position + transform.forward * size * 2);
  }

  private void OnDrawGizmosSelected() {
    float size = 0.25f;
    Gizmos.color = DeadEnd ? Color.red : Connected ? Color.white : Color.green;
    Gizmos.DrawSphere(transform.position, size);
  }
}