﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(Pathfinding.AIDestinationSetter))]
public class Enemy : MonoBehaviour {

  public float attackDist = 2f;
  public float attackTime = 1f;
  public float attackEnd = 0.8f;
  public float attackCooldown = 1f;
  public float attackMod = 1.2f;

  private Player player;
  private Pathfinding.AIDestinationSetter destinationSetter;
  private Pathfinding.AIPath path;
  private GameController gc;
  private Animator anim;
  private float attackTimer;
  private float attackCooldownTimer = 0f;
  private float origspd;

  private void Start() {
    anim = GetComponent<Animator>();
    destinationSetter = GetComponent<Pathfinding.AIDestinationSetter>();
    path = GetComponent<Pathfinding.AIPath>();

    // TODO: Come up with a better pattern for this race condition.
    if (player != null) {
      destinationSetter.target = player.transform;
    }

    origspd = path.maxSpeed;
  }

  private void Update() {
    attackCooldownTimer -= Time.deltaTime;
    anim.SetFloat("Speed", path.maxSpeed / 6f);

    if (destinationSetter.target == null && player != null) {
      destinationSetter.target = player.transform;
    }

    //if (attackCooldownTimer <= 0 &&
    //    (player.transform.position - transform.position).magnitude < attackDist) {
    //  StartCoroutine(AttackRoutine());
    //}
    if ((player.transform.position - transform.position).magnitude < attackDist) {
      path.maxSpeed = origspd * attackMod;
    } else {
      path.maxSpeed = origspd;
    }
  }

  private IEnumerator AttackRoutine() {
    attackCooldownTimer = attackCooldown;
    var orig = path.maxSpeed;
    path.maxSpeed = orig * attackMod;
    yield return new WaitForSeconds(attackTime);
    path.maxSpeed = orig * (1 / attackMod);
    yield return new WaitForSeconds(attackTime / 2);
    path.maxSpeed = orig;
  }

  public void SetPlayer(Player player) {
    this.player = player;

    // TODO: Come up with a better pattern for this race condition.
    if (destinationSetter != null) {
      destinationSetter.target = player.transform;
    }
  }

  public void NotifyThrowable(Pickup p) {
    destinationSetter.target = p.transform;
  }

  public void NotifyPickupBall(Pickup p) {
    if (destinationSetter.target == p.transform) {
      destinationSetter.target = player.transform;
    }
  }
}
