﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class IsoCamera : MonoBehaviour {
  public float distance;
  public float tilt = 60;

  private new Camera camera;

  private void Start() {
    Apply();
  }

  [Ice.ExposeMethod]
  private void Apply() {
    if (camera == null) {
      camera = GetComponent<Camera>();
    }

    camera.orthographic = true;
    camera.orthographicSize = distance;
    transform.rotation = Quaternion.Euler(tilt, 45, 0);
  }
}
