﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Occluder : MonoBehaviour {
  [SerializeField]
  private Renderer[] renderers;

  [SerializeField]
  private float strength = 0.5f;

  private Color[] colors;

  private void Start() {
    colors = new Color[renderers.Length];
    for (int i = 0; i < renderers.Length; i++) {
      colors[i] = renderers[i].material.color;
    }
  }

  public void StartOccluding() {
    for (int i = 0; i < renderers.Length; i++) {
      renderers[i].material.color = new Color(colors[i].r, colors[i].g, colors[i].b, strength);
    }
  }

  public void StopOccluding() {
    for (int i = 0; i < renderers.Length; i++) {
      renderers[i].material.color = colors[i];
    }
  }
}
