﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

// Replace materials with transparent ones when the player is occluded.
public class PlayerOcclusion : MonoBehaviour {
  public Transform player;
  public float distance;

  private int playerLayer;
  private Occluder lastPlayerOccluder;

  private void Start() {
    playerLayer = LayerMask.NameToLayer("Player");
  }

  private void Update() {
    // TODO: Maybe do this every other frame or something if its expensive?
    int mask = LayerMask.GetMask("Occluder", "Player");
    RaycastHit hit;
    var toCamera = (player.position + Vector3.down * 0.5f) - transform.position;
    var ray = new Ray(transform.position, toCamera);
    Debug.DrawRay(transform.position, toCamera * distance);
    if (Physics.Raycast(ray, out hit, distance, mask)) {
      if (hit.transform.gameObject.layer != playerLayer) {
        // Something is occluding the player.
        var comp = hit.collider.GetComponent<Occluder>();
        if (comp != lastPlayerOccluder) {
          StopOccluding();
          StartOccluding(comp);
        }
        return;
      }
    }

    StopOccluding();
  }

  private void StartOccluding(Occluder o) {
    o.StartOccluding();
    lastPlayerOccluder = o;
  }

  private void StopOccluding() {
    if (lastPlayerOccluder == null) {
      return;
    }
    lastPlayerOccluder.StopOccluding();
    lastPlayerOccluder = null;
  }
}
