﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Tween {
  private float dt;
  private float duration;
  private Action<float> callback;

  public Tween(float duration, Action<float> callback) {
    this.duration = duration;
    this.callback = callback;
  }

  public IEnumerator Start() {
    while (dt < duration) {
      dt += Time.deltaTime;
      Debug.Log("Starting with " + dt);
      callback(dt / duration);
      yield return null;
    }
  }
}
