﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ThrowIndicator : MonoBehaviour {
  public float radius = 5f;
  public int count = 20;

  private Renderer lr;

  private void Start() {
    lr = GetComponent<LineRenderer>();
  }

  private void Update() {
    lr.material.mainTextureOffset = new Vector2(Time.time, 1f);
  }

  [Ice.ExposeMethod]
  public void SetRenderer() {
    var lr = GetComponent<LineRenderer>();
    var positions = new Vector3[count + 1];
    for (int i = 0; i < count + 1; i++) {
      var radians = Mathf.Deg2Rad * (i * 360f / count);
      positions[i] = new Vector3(
          Mathf.Sin(radians) * radius,
          0,
          Mathf.Cos(radians) * radius);
    }
    lr.positionCount = count + 1;
    lr.SetPositions(positions);
  }
}