﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class UIController : MonoBehaviour {
  public TMPro.TextMeshProUGUI exploredText;
  public TMPro.TextMeshProUGUI batteryText;
  public TMPro.TextMeshProUGUI clock;
  public Image pickupImage;
  public GameObject introText;
  public GameObject deathText;
  public GameObject winText;

  public void StartGame() {
    SceneManager.LoadScene("Game");
  }

  public void ShowBall() {
    pickupImage.gameObject.SetActive(true);
  }

  public void HidePickup() {
    pickupImage.gameObject.SetActive(false);
  }

  public void HideIntroText() {
    introText.SetActive(false);
  }

  public void SetExploredAmount(float amt) {
    amt *= 100;
    amt = Math.Min(amt, 100);
    exploredText.text = string.Format("{0:F1}% of campground explored", amt);
  }

  public void UpdateTime(DateTime dt) {
    var midnight = new DateTime(2005, 1, 1, 11, 59, 0);
    var display = new DateTime(Math.Min(midnight.Ticks, dt.Ticks));
    clock.text = display.ToString("hh:mm") + " pm";
  }

  public void UpdateBattery(float charge) {
    charge *= 100;
    batteryText.text = String.Format("Headlamp charge: {0:F1}%", charge);
  }

  public void ShowDeath() {
    deathText.SetActive(true);
  }

  public void ShowWin() {
    winText.SetActive(true);
  }

  public void Reset() {
    introText.SetActive(true);
    deathText.SetActive(false);
  }
}