Sprite = Object:extend()

function Sprite:init(image)
    self.image = image
end

function Sprite:draw()
    love.graphics.draw(self.image, 0, 0)
end


Animation = Sprite:extend()

local DEFSPEED = 1 / 20

function Animation:init(image, framewidth, speed)
    self.image = image
    self.frame = 0
    self.nframes = image:getWidth() / framewidth
    self.quads = {}
    self.speed = speed or DEFSPEED
    self.block = false
    self.direction = 1
    for i=0, self.nframes do
        self.quads[i] = love.graphics.newQuad(i * framewidth, 0, framewidth, image:getHeight(), 
                                             image:getWidth(), image:getHeight())
    end
    self.timer = time.every(self.speed, function() self:advance() end)
end

function Animation:forwardOnce()
    self.direction = 1
    self.block = true
end

function Animation:reverseOnce()
    self.direction = -1
    self.block = true
end

function Animation:advance()
    if self.direction > 0 then
        self.frame = self.frame + self.direction
        if self.frame >= self.nframes then
            if self.block then
                self.frame = self.nframes - 1
            else
                self.frame = 0
            end
        end
    elseif self.direction < 0 then
        self.frame = self.frame + self.direction
        if self.frame < 0 then
            if self.block then
                self.frame = 0
            else
                self.frame = self.nframes - 1
            end
        end
    end
end

function Animation:draw()
    love.graphics.drawq(self.image, self.quads[self.frame], 0, 0)
end

