assets = {}

function assets.load()
    assets.gfx = leaf.fs.loadImages('gfx', assets.loaded)
    assets.sfx = leaf.fs.loadSounds('sfx', assets.loaded)
    assets.music = leaf.fs.loadSounds('music', assets.loaded)
    assets.maps = leaf.fs.loadChunks('maps', assets.loaded)
    assets.shaders = leaf.fs.loadShaders('shaders', assets.loaded)

    for k, img in pairs(assets.gfx) do
        img:setFilter('nearest', 'nearest')
    end

    assets.font = {
        small = love.graphics.newFont('font/font.ttf', 32),
        large = love.graphics.newFont('font/font.ttf', 48),
        huge = love.graphics.newFont('font/font.ttf', 72),
    }
end

function assets.loaded(path)
    console:write("Loaded asset " .. path)
end
