local MESSAGE_SPEED = 0.035

dialog = {
    active = nil,
    timer = nil,
    queue = Queue(),
    color = {
        fg = {255, 255, 255},
        bg = {33, 6, 128, 128},
        border = {99, 25, 255, 255} 
    },
    rect = Rect(love.graphics.getWidth() / 4, love.graphics.getHeight() / 2, 
                love.graphics.getWidth() * 3 / 4, love.graphics.getHeight() * 11 / 16),
}

dialog.rect:centerScale(1.25)
dialog.rect:translate(-16, 0)

dialog.snd = 0

local Message = Object:extend()

function Message:init(text, callback)
    self.text = text
    self.callback = callback
    self.completed = false
    self.chars = 0
    self.total = text:len()
end

function Message:substr()
    return self.text:sub(0, self.chars)
end

function Message:forceComplete()
    self.chars = self.total
    self.completed = true
end


function dialog:clear()
    self.queue:clear()
    self.active = nil
    if self.timer then
        self.timer:kill()
        self.timer = nil
    end
end

function dialog:update(dt)
    if not self.queue:isEmpty() then
        if not self.active then
            self.active = self.queue:pop()
            self.timer = time.every(MESSAGE_SPEED, function() self:nextChar() end)
        end
    end
end

function dialog:sound()
    if dialog.snd == 0 then
        dialog.snd = 1
        game.playSound('char')
    else
        dialog.snd = 0
    end
end

function dialog:nextChar()
    if not self.active.completed then
        self:sound()
        self.active.chars = self.active.chars + 1
        if self.active.chars >= self.active.total then
            self.active.completed = true
            self.timer:kill()
        end
    end
end

function dialog:draw()
    if self.active then
        -- Draw box
        love.graphics.setColor(self.color.bg)
        love.graphics.rectangle('fill', self.rect:unpack())
        love.graphics.setColor(self.color.border)
        love.graphics.setLineWidth(2)
        love.graphics.rectangle('line', self.rect:unpack())
        love.graphics.setFont(assets.font.small)

        -- Draw text
        love.graphics.setColor(unpack(self.color.fg))
        love.graphics.printf(self.active:substr(), self.rect.left + 25, 
                             self.rect.top + 25, self.rect:w() - 50)

        if self.active.completed then
            local x, y = self.rect.right - 50, self.rect.bottom - 50
            love.graphics.polygon('fill', x, y, x+16, y, x+8, y+10)
        end
    end
end

function dialog:keypressed(key, unicode)
    if self.active then
        self:advance()
        return true
    end
    return false
end

function dialog:advance()
    if not self.active.completed then
        self.active:forceComplete()
        self.timer:kill()
    else
        if type(self.active.callback) == 'function' then
            self.active.callback()
        end
        self.active = nil
    end
end

function dialog:push(text, callback)
    if text == "PRINTSCORE" then
        text = "You completed with " .. game.getClockText() .. " remaining."
    end
    self.queue:push(Message(text, callback))
end
