require 'entity'

Friend = Entity:extend()

function Friend:init()
    self.w = player.w
    self.h = player.h
    self.sprites = {
        idle = Animation(assets.gfx.friend_idle, 10, 0.5),
        jump = Animation(assets.gfx.friend_run, 10, 0.02),
        run = Animation(assets.gfx.friend_run, 10),
    }
    self.sprite = self.sprites.idle

    self.wait_y = true
end

function Friend:update(dt)
    local dx, dy = player.x - self.x, player.y - self.y
    if math.abs(dx) > 10 then
        self.x = self.x + 0.5 * dx * dt * 2
        self.sprite = self.sprites.run
        if dx > 0 then
            self.left = false
        else
            self.left = true
        end
    else
        self.sprite = self.sprites.idle
    end
    if not player.y_history:isEmpty() then
        if not self.wait_y then
            self.y = player.y_history:pop()
        elseif player.y_history:len() > 4 then
            self.wait_y = false
        end
    else
        self.wait_y = true
    end
end

function Friend:draw()
    if not player.dead then
        Entity.draw(self)
    end
end
