Entity = Object:extend()

function Entity:init(prop)
    local prop = prop or {}
    self.x = prop.x or 0
    self.y = prop.y or 0
    self.w = prop.w or 20
    self.h = prop.h or 20
    self.orientation = prop.orientation or 0

    -- Physics
    self.velx = 0
    self.vely = 0
    self.accx = 0
    self.accy = 0

    -- Graphics
    if prop.left == nil then
        self.left = true
    else
        self.left = prop.left
    end
end

-- Adjust world placement
function Entity:adjust()
end

function Entity:translate(x, y)
    self.x = self.x + x
    self.y = self.y + y
end

function Entity:rotate(n)
    self.orientation = (self.orientation + n) % 4
    if self.orientation < 0 then
        self.orientation = 3
    end
end

function Entity:cx()
    return self.x + self.w / 2
end

function Entity:cy()
    return self.y + self.h / 2
end

function Entity:getRect()
    return Rect(self.x, self.y, self.x+self.w, self.y+self.h)
end

function Entity:fixCollision(rect)
    return rect
end

function Entity:getCollisionRect()
    local rect = self:getRect()
    return self:fixCollision(rect)
end

function Entity:getTriggerRect()
    return nil
end

function Entity:trigger()
    -- NOP
end

function Entity:transformDraw()
    love.graphics.push()
        love.graphics.translate(self.x, self.y)
        if self.left then
            love.graphics.scale(-1, 1)
            love.graphics.translate(-self.w, 0)
        end
        self:draw()
    love.graphics.pop()
end

function Entity:draw()
    self.sprite:draw()
end

function Entity:update(dt)
    -- NOP
end

-- Return new positions from iterating physics
function Entity:stepPhysics(dt)
    self.velx = self.velx + self.accx * dt
    self.vely = self.vely + self.accy * dt
    local x   = self.x + self.velx * dt
    local y   = self.y + self.vely * dt
    return x, y
end
