require 'planet'

Level = Object:extend()

function Level:init(opt)
    opt = opt or {}
    for k, v in pairs(opt) do
        self[k] = v
    end
end

function Level:loadPlanet()
    return Planet(self.planet_def)
end

function Level:getDialog()
    local dlg = self.dialog
    self.dialog = nil
    return dlg or {}
end

local bg1 = {127, 178, 240}
local bg2 = {102, 178, 255}
local bg3 = {50, 154, 255}

local bg4 = {180, 185, 230}
local bg5 = {140 , 120, 255}

local bg6 = {127, 178, 240}
local bg7 = {50, 154, 255}

levels = {
    -- Level {
    --     planet_def = {
    --         map = 'test',
    --         bgcolor = {127, 178, 240},
    --     },
    -- },
    Level {
        planet_def = {
            map = 'level1',
            bgcolor = bg1,
        },
        dialog = {
            "SCIENTIST: Our star system is under imminent danger from the wandering corsairs!",
            "SCIENTIST: We need to get to the primary defense station before they do and secure the defense grid.",
            "SCIENTIST: Unfortunately... there's not much time left.  We have to get to Alpha Station in under fifteen minutes.",
            "SCIENTIST: We can reach Alpha Station from the outermost planet in the system.  Each planet should have a gate connecting to the next one.",
            "SCIENTIST: Looks like theres a gate right over there.  We must hurry!!",
        },
    },
    Level {
        planet_def = {
            map = 'level2',
            bgcolor = bg1,
        },
    },
    Level {
        planet_def = {
            map = 'level2b',
            bgcolor = bg1,
        },
    },
    Level {
        planet_def = {
            map = 'level2c',
            bgcolor = bg1,
        },
    },
    Level {
        planet_def = {
            map = 'level3',
            bgcolor = bg2,
        },
        dialog = {
            "SCIENTIST: Careful!  It looks like the attackers embedded a gravity controller in this planet.  As long as it stands it controls the force of gravity here.",
            "SCIENTIST: If you listen carefully, you can hear a signal coming from the device when it's about to activate.",
            "SCIENTIST: We should try our best to keep our feet off the ground during a shift in gravity...",
        },
        gravity = {
            dir = -1,
            time = {4, 4},
        }
    },
    Level {
        planet_def = {
            map = 'level4',
            bgcolor = bg2,
        },
        gravity = {
            dir = -1,
            time = {4, 4},
        }
    },
    Level {
        planet_def = {
            map = 'level5',
            bgcolor = bg2,
        },
    },
    Level {
        planet_def = {
            map = 'level6',
            bgcolor = bg2,
        },
        gravity = {
            dir = 1,
            time = {3, 3},
        },
    },
    Level {
        planet_def = {
            map = 'level6b',
            bgcolor = bg3,
        },
        gravity = {
            dir = 1,
            time = {3, 3},
        },
    },
    Level {
        planet_def = {
            map = 'level7',
            bgcolor = bg3,
        },
        gravity = {
            dir = 1,
            time = {4, 4},
        },
    },
    Level {
        planet_def = {
            map = 'level7b',
            bgcolor = bg3,
        },
        gravity = {
            dir = -1,
            time = {5, 5},
        },
    },
    Level {
        planet_def = {
            map = 'level8',
            bgcolor = bg3,
        },
    },
    Level {
        planet_def = {
            map = 'level9',
            bgcolor = bg3,
        },
        gravity = {
            time = {3, 5},
        }
    },
    Level {
        planet_def = {
            map = 'w2level1',
            bgcolor = bg4,
        },
        gravity = {
            time = {3, 5},
        }
    },
    Level {
        planet_def = {
            map = 'w2level2',
            bgcolor = bg4,
        },
        gravity = {
            time = {2, 4},
        }
    },
    Level {
        planet_def = {
            map = 'w2level3',
            bgcolor = bg4,
        },
        gravity = {
            dir = -1,
            delay = 1,
            time = {1, 1},
        }
    },
    Level {
        planet_def = {
            map = 'w2level4',
            bgcolor = bg4,
        },
        dialog = {
            "SCIENTIST: It looks like they sent guards to try and stop us.  They'll be able to attack us from a range, so be careful.",
            "SCIENTIST: Let's go!",
        },
    },
    Level {
        planet_def = {
            map = 'w2level5',
            bgcolor = bg4,
        },
    },
    Level {
        planet_def = {
            map = 'w2level6',
            bgcolor = bg5,
        },
        gravity = {
            time = {3, 5},
        }
    },
    Level {
        planet_def = {
            map = 'w2level7',
            bgcolor = bg5,
        },
        gravity = {
            time = {2, 3},
        }
    },
    Level {
        planet_def = {
            map = 'w2level7b',
            bgcolor = bg5,
        },
        gravity = {
            time = {3, 5},
        }
    },
    Level {
        planet_def = {
            map = 'w2level8',
            bgcolor = bg5,
        },
        gravity = {
            time = {3, 5},
        }
    },
    Level {
        planet_def = {
            map = 'w3level1',
            bgcolor = bg6,
        },
    },
    Level {
        planet_def = {
            map = 'w3level2',
            bgcolor = bg6,
        },
        gravity = {
            time = {3, 4},
        }
    },
    Level {
        planet_def = {
            map = 'w3level3',
            bgcolor = bg6,
        },
        gravity = {
            dir = 1,
            time = {2, 2},
        }
    },
    Level {
        planet_def = {
            map = 'w3level4',
            bgcolor = bg6,
        },
        gravity = {
            time = {3, 4},
        }
    },
    Level {
        planet_def = {
            map = 'w3level5',
            bgcolor = bg6,
        },
    },
    Level {
        planet_def = {
            map = 'w3level5b',
            bgcolor = bg7,
        },
        gravity = {
            dir = 1,
            time = {3, 3},
        },
    },
    Level {
        planet_def = {
            map = 'w3level6',
            bgcolor = bg7,
        },
        gravity = {
            time = {5, 7},
        },
    },
    Level {
        planet_def = {
            map = 'w3level6b',
            bgcolor = bg7,
        },
        gravity = {
            dir = -1,
            delay = 1,
            time = {1, 1},
        },
    },
    Level {
        planet_def = {
            map = 'w3level7',
            bgcolor = bg7,
        },
        gravity = {
            time = {3, 6},
        }
    },
    Level {
        planet_def = {
            map = 'end',
            bgcolor = {0, 0, 80},
        },
        dialog = {
            "SCIENTIST: We made it...",
            "Thanks for playing my very unfinished Ludum Dare entry",
            "Game created by Josh Bothun",
            "PRINTSCORE",
        }
    },
}

