inspect = require 'lib/inspect'
tween = require 'lib/tween'

require 'leaf'

-- Import leaf namespace
Camera      = leaf.Camera
Console     = leaf.Console
List        = leaf.List
Set         = leaf.Set
Stack       = leaf.Stack
Queue       = leaf.Queue
Context     = leaf.Context
Object      = leaf.Object
Rect        = leaf.Rect
Vector      = leaf.Vector
time        = leaf.time

require 'game'
require 'assets'

local titleScreen = Context()
titleScreen.color = {255, 255, 255}

function titleScreen.draw()
    love.graphics.setColor(unpack(titleScreen.color))
    love.graphics.push()
        love.graphics.scale(8, 8)
        love.graphics.draw(assets.gfx.title, 0, 0)
    love.graphics.pop()
end

function titleScreen.update(dt)
    titleScreen.color = {
        math.random(0, 255),
        math.random(0, 255),
        math.random(0, 255),
    }
end


function titleScreen.keypressed(key, unicode)
    if key == 'escape' then
        require 'os'
        os.exit()
    else
        runGame()
    end
end

function love.load()
    -- Setup global objects
    console = Console()

    -- Load game assets
    assets.load()
    assets.sfx.start:play()

    -- Setup toplevel love callback object
    app = leaf.app
    app.bindLove()
    app.pushContext(titleScreen)
end

function runGame()
    app.popContext()
    app.pushContext(game)
    game.load()
    assets.music.music:setVolume(0.6)
    assets.music.music:play()
end

