Menu = Object:extend()

local bgcolor = {200, 0, 0}
local fgcolor = {255, 255, 255}

function Menu:init(message)
    self.message = message
    self.choices = {}
    self.selected = 1
    local pad = 150
    self.rect = Rect(0, 0, love.graphics.getWidth(), love.graphics.getHeight())
end

function Menu:push(text, callback)
    table.insert(self.choices, {text, callback})
end

function Menu:draw()
    love.graphics.setColor(unpack(bgcolor))
    love.graphics.rectangle('fill', self.rect:unpack())
    love.graphics.setColor(unpack(fgcolor))
    love.graphics.setFont(assets.font.huge)
    love.graphics.printf(self.message, 0, love.graphics.getHeight() / 3,
                         love.graphics.getWidth(), 'center')
    for i, v in ipairs(self.choices) do
        local text = v[1]
        local spacing = 60
        local top = love.graphics.getHeight() * 3 / 5
        love.graphics.setFont(assets.font.large)
        love.graphics.setColor(unpack(fgcolor))
        if self.selected == i then
            love.graphics.rectangle('fill', 0, top + spacing*(i - 1) - 20, 
                                    love.graphics.getWidth(), spacing)
            love.graphics.setColor(unpack(bgcolor))
        end
        love.graphics.printf(text, 0, top + spacing*(i-1),
                             love.graphics.getWidth(), 'center')
    end
end

function Menu:keypressed(key, unicode)
    if key == 'w' or key == 'up' then
        self.selected = self.selected - 1
        if (self.selected < 1) then
            self.selected = #self.choices
        end
    elseif key == 's' or key == 'down' then
        self.selected = self.selected + 1
        if (self.selected > #self.choices) then
            self.selected = 1
        end
    else
        return self:accept()
    end
end

function Menu:accept()
    game.activeMenu = nil
    return self.choices[self.selected][2]()
end
