particles = {}

particles.systems = {}
particles.colors = {}

local BUFFER = 1000

function particles:init()
    -- Preconstruct all particle systems
    self:add('death', {
        image = assets.gfx.particle_a,
        rate = 1000,
        lifetime = 0.1,
        accel = {0, 0},
        speed = {125, 250},
    })
    self:add('ping_right', {
        image = assets.gfx.particle_ping_right,
        size = {1.0, 10.0},
        buffer = 1,
        lifetime = 0.001,
        life = {1,1},
        speed = {0, 0},
        rate = 1000,
        colors = {255, 255, 255, 255, 255, 255, 255, 0},
    })
    self:add('ping_left', {
        image = assets.gfx.particle_ping_left,
        size = {1.0, 10.0},
        buffer = 1,
        lifetime = 0.001,
        life = {1,1},
        speed = {0, 0},
        rate = 1000,
        colors = {255, 255, 255, 255, 255, 255, 255, 0},
    })
end

function particles:enable(name, x, y)
    local system = self.systems[name]
    if system then
        system:setPosition(x, y)
        system:reset()
        system:start()
    end
end

function particles:disable(name)
    local system = self.systems[name]
    if system then
        system:reset()
        system:stop()
    end
end

function particles:add(name, prop)
    local system = love.graphics.newParticleSystem(prop.image, prop.buffer or BUFFER)
    system:setSizes(unpack(prop.size or {1.0, 1.0}))
    system:setColors(unpack(prop.colors or {255, 255, 255, 255}))
    system:setEmissionRate(prop.rate or 100)
    system:setLifetime(prop.lifetime or -1)
    system:setParticleLife(unpack(prop.life or {10, 10}))
    system:setRadialAcceleration(unpack(prop.accel or {10, 10}))
    system:setSpread(prop.spread or 10)
    system:setSpeed(unpack(prop.speed or {50, 50}))
    system:stop()
    self.colors[name] = prop._color or {255, 255, 255}
    self.systems[name] = system
end

function particles:update(dt)
    for name, system in pairs(self.systems) do
        system:update(dt)
    end
end

function particles:draw()
    for name, system in pairs(self.systems) do
        love.graphics.setColor(255, 255 ,255)
        love.graphics.draw(system)
    end
end
