const float blurSize = 1.0/512.0;

extern float mod;

vec4 effect(vec4 global_color, sampler2D texture, vec2 texcoord, vec2 pixel_coords)
{
    vec4 sum = vec4(0.0);
    sum += texture2D(texture, vec2(texcoord.x - 4.0*blurSize*mod*5, texcoord.y)) * 0.05;
    sum += texture2D(texture, vec2(texcoord.x - 3.0*blurSize*mod*5, texcoord.y)) * 0.09;
    sum += texture2D(texture, vec2(texcoord.x - 2.0*blurSize*mod*5, texcoord.y)) * 0.12;
    sum += texture2D(texture, vec2(texcoord.x - blurSize*mod*5, texcoord.y)) * 0.15;
    sum += texture2D(texture, vec2(texcoord.x, texcoord.y)) * 0.16;
    sum += texture2D(texture, vec2(texcoord.x + blurSize*mod*5, texcoord.y)) * 0.15;
    sum += texture2D(texture, vec2(texcoord.x + 2.0*blurSize*mod*5, texcoord.y)) * 0.12;
    sum += texture2D(texture, vec2(texcoord.x + 3.0*blurSize*mod*5, texcoord.y)) * 0.09;
    sum += texture2D(texture, vec2(texcoord.x + 4.0*blurSize*mod*5, texcoord.y)) * 0.05;
    return sum;
}